<?php

/** @var yii\web\View $this */

use yii\bootstrap5\Html;
use yii\helpers\Url;

$this->title = 'My Yii Application';
?>
<body>
<div class="container">
    <section class="hotel-section">
        <h2>Отель "Как дома"</h2>
        <div class="hotel-description">
            <p>Отель "Как дома" — это уютное место для отдыха, где каждый гость чувствует себя как дома. Мы предлагаем
                комфортабельные номера, внимательный персонал и все необходимое для приятного пребывания.</p>
        </div>
        <div class="media-section">
            <div class="photo-gallery">
                <h3>Фотоотчеты</h3>
                <div class="gallery">
                    <?= Html::img('@web/images/z.jpg', ['alt' => 'My logo']) ?>
                    <?= Html::img('@web/images/x.jpg', ['alt' => 'My logo']) ?>
                    <?= Html::img('@web/images/f.jpg', ['alt' => 'My logo']) ?>
                </div>
            </div>

            <div class="video-gallery">
                <h3>Видеоролики</h3>
                <video width="500" controls>
                    <source src="<?= Yii::getAlias('@web/images/h.mp4') ?>" type="video/mp4">
                    Ваш браузер не поддерживает видео тег.
                </video>
                </div>
            </div>
        </div>

        <div class="advantages">
            <div class="advantage-card">
                <i>📍</i>
                <h3>Расположение</h3>
                <p>Центральное расположение вблизи достопримечательностей и транспортных узлов</p>
            </div>

            <div class="advantage-card">
                <i>🛌</i>
                <h3>Комфорт</h3>
                <p>Просторные номера с современной мебелью и качественным постельным бельем</p>
            </div>

            <div class="advantage-card">
                <i>🎯</i>
                <h3>Услуги</h3>
                <p>Круглосуточное обслуживание, ресторан, спа, трансфер и многое другое</p>
            </div>
        </div>
    </section>
    <section class="services-section">
        <h2>Услуги и дополнительные опции</h2>
        <div class="services-grid">
            <div class="service-card">
                <div class="service-icon">🍽️</div>
                <h3>Ресторан</h3>
                <p class="service-description">Наш ресторан предлагает блюда европейской и местной кухни. Завтрак
                    включен в стоимость проживания.</p>
                <div class="service-time">07:00 - 23:00</div>
            </div>
            <div class="service-card">
                <div class="service-icon">💆</div>
                <h3>Спа-центр</h3>
                <p class="service-description">Расслабляющие массажи, сауна, хаммам и косметические процедуры для
                    полного релакса.</p>
                <div class="service-time">10:00 - 22:00</div>
            </div>
            <div class="service-card">
                <div class="service-icon">💪</div>
                <h3>Спортзал</h3>
                <p class="service-description">Современный фитнес-центр с кардио- и силовыми тренажерами. Открыт 24/7
                    для гостей отеля.</p>
                <div class="service-time">круглосуточно</div>
            </div>
            <div class="service-card">
                <div class="service-icon">🗺️</div>
                <h3>Экскурсии</h3>
                <p class="service-description">Организуем индивидуальные и групповые экскурсии по главным
                    достопримечательностям города.</p>
                <div class="service-time">бронирование за 24 часа</div>
            </div>
            <div class="service-card">
                <div class="service-icon">📊</div>
                <h3>Конференц-зал</h3>
                <p class="service-description">Проведение деловых встреч, семинаров и конференций. Современное
                    оборудование.</p>
                <div class="service-time">08:00 - 20:00</div>
            </div>
            <div class="service-card">
                <div class="service-icon">🏊</div>
                <h3>Бассейн</h3>
                <p class="service-description">Крытый подогреваемый бассейн с зоной отдыха. Для взрослых и детей.</p>
                <div class="service-time">07:00 - 22:00</div>
            </div>
            <div class="service-card">
                <div class="service-icon">👔</div>
                <h3>Прачечная</h3>
                <p class="service-description">Услуги химчистки и стирки белья. Срочные услуги доступны по запросу.</p>
                <div class="service-time">09:00 - 19:00</div>
            </div>
        </div>
    </section>
</div>
</body>

