<?php

use app\models\Application;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\ApplicationSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Брони номеров';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="application-index">

    <h1>Брони номеров</h1>


    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'content:ntext',
            [
                'attribute' => 'user_id',
                'value' => function($model) {
                    return $model->user->name;
                },
                'filter' => \yii\helpers\ArrayHelper::map(\app\models\User::find()->all(), 'id', 'login')
            ],
            [
                'attribute' => 'hotelnumber_id',
                'value' => function($model) {
                    return $model->hotelnumber->name;
                },
            ],
            'adults',
            'kinders',
            'date_here',
            'date_out',
            [
                'attribute' => 'payment_method',
                'value' => function($model) {
                    $methods = [
                        0 => 'наличными',
                        1 => 'Банковской картой'
                    ];
                    return $methods[$model->payment_method] ?? 'Неизвестно';
                },
            ],
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Application $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                }
            ],
        ],
    ]); ?>


</div>
