<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property string|null $content
 * @property int $user_id
 * @property int $hotelnumber_id
 * @property int $adults
 * @property int $kinders
 * @property string $date_here
 * @property string $date_out
 * @property int $payment_method
 * @property string $status
 *
 * @property Hotelnumber $hotelnumber
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['content'], 'default', 'value' => null],
            [['status'], 'default', 'value' => 'Новая'],
            [['content'], 'string'],
            [['user_id', 'hotelnumber_id', 'adults', 'kinders', 'date_here', 'date_out', 'payment_method'], 'required'],
            [['user_id', 'hotelnumber_id', 'adults', 'kinders', 'payment_method'], 'integer'],
            [['date_here', 'date_out', 'status'], 'string', 'max' => 60],
            [['hotelnumber_id'], 'unique'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['hotelnumber_id'], 'exist', 'skipOnError' => true, 'targetClass' => Hotelnumber::class, 'targetAttribute' => ['hotelnumber_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'content' => Yii::t('app', 'Поле для доп. услуг'),
            'user_id' => Yii::t('app', 'Пользователь'),
            'hotelnumber_id' => Yii::t('app', 'Вид номера'),
            'adults' => Yii::t('app', 'Взрослых'),
            'kinders' => Yii::t('app', 'Детей'),
            'date_here' => Yii::t('app', 'Дата заезда'),
            'date_out' => Yii::t('app', 'Дата отъезда'),
            'payment_method' => Yii::t('app', 'Способ оплаты'),
            'status' => Yii::t('app', 'Статус бронирования'),
        ];
    }

    /**
     * Gets query for [[Hotelnumber]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getHotelnumber()
    {
        return $this->hasOne(Hotelnumber::class, ['id' => 'hotelnumber_id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
